*! version 2.0
* 28 April 2021
* NIDS-CRAM
* This do-file contains the code to create deflators to deflate NIDS Wave 5 financial data. Deflated values can be generated by multiplying 
* the relevant financial data variable by the deflator generated by this do-file.

*=====================================================================================================================================
/*

THIS DO FILE CREATES DEFLATORS FOR USE WITH THE MERGED WAVE 5 NIDS DATASET AND THE NIDS-CRAM DATASET.
BASE MONTH IS FEB 2020 AND INTERVIEW DATES ARE TAKEN FROM THE HOUSEHOLD QUESTIONNAIRE. MISSING INTERVIEW MONTHS ARE IMPUTED TO THE MODAL MONTH FOR THE RELEVANT WAVE.

PRICE INDICES ARE FROM THE NATIONAL HEADLINE CPI INDEX PUBLISHED BY STATS SA, AVAILABLE HERE:
http://www.statssa.gov.za/publications/P0141/CPIHistory.pdf??
*/
*=====================================================================================================================================

*=====================================================================================================================================

* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global W5Data "C:\Users\Dropbox\Data\NIDS\Data\w5"				//File path to where input data is located. Change this path according to where your data folder is located on your computer.
global W5VerIN "W5_Anon_V1.0.0"

global DataOUT "C:\Users\Dropbox\Data\NIDS\Data\w5_d"			//File path to where you want to save subsequent data files. 
global VersionOUT "merged"

global temp "C:\Users\Desktop"									//Tempfile to hold all the working datasets, all working datasets will be deleted from this folder at the completion of the do file execution.
																		
version 16.0													//Version of Stata being used

clear
cap clear matrix
set more off

scalar base=115.2 												//Set scalar to base month, currently Feb 2020

*=====================================================================================================================================


* HOUSEHOLD QUESTIONNAIRE
use "$W5Data\HHQuestionnaire_$W5VerIN.dta", clear

*Wave 5
gen w5_deflator=.
replace w5_deflator=base/100.6 if w5_h_intrv_m==1 & w5_h_intrv_y==2017
replace w5_deflator=base/101.7 if w5_h_intrv_m==2 & w5_h_intrv_y==2017
replace w5_deflator=base/102.3 if w5_h_intrv_m==3 & w5_h_intrv_y==2017
replace w5_deflator=base/102.4 if w5_h_intrv_m==4 & w5_h_intrv_y==2017
replace w5_deflator=base/102.7 if w5_h_intrv_m==5 & w5_h_intrv_y==2017
replace w5_deflator=base/102.9 if w5_h_intrv_m==6 & w5_h_intrv_y==2017
replace w5_deflator=base/103.2 if w5_h_intrv_m==7 & w5_h_intrv_y==2017
replace w5_deflator=base/103.3 if w5_h_intrv_m==8 & w5_h_intrv_y==2017
replace w5_deflator=base/103.8 if w5_h_intrv_m==9 & w5_h_intrv_y==2017
replace w5_deflator=base/104.1 if w5_h_intrv_m==10 & w5_h_intrv_y==2017
replace w5_deflator=base/104.2 if w5_h_intrv_m==11 & w5_h_intrv_y==2017
replace w5_deflator=base/104.7 if w5_h_intrv_m==12 & w5_h_intrv_y==2017

replace w5_deflator=base/102.4 if w5_h_intrv_m==. & w5_h_outcome==1

lab var w5_deflator "NIDS Wave 5 deflator"

keep w5_hhid w5_deflator

merge 1:1 w5_hhid using "$W5Data\hhderived_$W5VerIN.dta"
drop _merge

save "$DataOUT\deflated_W5_$VersionOUT.dta", replace

*=====================================================================================================================================

* end of do file





















